#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Give it MoireMod01.fsh  by   willstall   
//https://www.shadertoy.com/view/3lj3zy
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#ifdef GL_ES
    precision mediump float;
#endif

#define PI 3.14159265359
#define HALF_PI 1.57079632675
#define TWO_PI 6.283185307

#define SECONDS 60.0

float random(vec2 st){ return fract(sin(dot(st.yx,vec2(14.7891,43.123)))*312991.41235); }
float random (in float x) { return fract(sin(x)*43758.5453123); }

float cell_random(float x,float scale)
{   
    float iPos = floor(x*scale);
    return mix(random(iPos), random(iPos + 1.0), smoothstep(0.,1.,fract(x*scale)));
}

mat2 rotate(float angle)
{
    return mat2( cos(angle),-sin(angle),sin(angle),cos(angle) );
}

vec2 center(vec2 st)
{
    float aspect = iResolution.x/iResolution.y;
    st.x = st.x * aspect - aspect * 0.5 + 0.5;
    return st;
}

float lines(vec2 st)
{
    st -= st.y-st.x;    // go diagonal
    return sin(st.x*10.0);
}

vec2 map(vec2 st, float t)
{
    vec2 pos = vec2(0.0);
        pos += vec2(0.4)*rotate(TWO_PI*t);
    
    st = st-pos;

    float freq = mix(1.5,2.25,cell_random(sin(PI + iTime*.15),5.0));
    float amount = mix(0.08,0.35,cell_random(sin(TWO_PI*.75+iTime*.0025),10.0));
    float c = length(st);
    float sq = mix(1.0,10.0, cell_random(sin(PI + iTime*.005),50.0));
    float scale = mix(sq,4.0,0.5+0.5*sin(st.x*st.y*st.y*4.0));
    vec2 uv = st + (c)*freq*cos(c*scale-TWO_PI*4.0)*amount;

    return uv;
}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 st = fragCoord/iResolution.xy;
    float t = fract(iTime/SECONDS);

    st = center(st);
    st = st * 2.0 - 1.0;
    st *= rotate(PI*0.25);
	st *= rotate(TWO_PI*iTime*0.0015);

    vec2 m = map(st,t);

    float r = cell_random(length(m)+iTime*0.023,10.0);

    float stripes = sin(m.x*50.0);
    float d = dot(m,st)+0.1;

    float c_repeats = mix(20.0,100.0,cell_random(sin(iTime*.035),10.0));

    vec3 c_sin = cos(vec3(0.15,.32,0.3)+d*c_repeats + iTime );
    vec3 color = c_sin-d-stripes;
        color += r;

    fragColor = vec4(color,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

